<!--
The purpose of this template is to provide a starting point for a well structured issue following our 
[Definition of Ready](https://handbook.gitlab.com/handbook/engineering/devops/dev/plan/product-planning/how-we-work/#definition-of-ready)

Note: Please also consider the searchability of the issue title to make it easier to find in the future.
-->

## Technical Description

<!--
What technical work needs to be done and why?

If this is a bug, include instructions on how to replicate it.

Does this change require any updates to the documentation?
-->

## Acceptance Criteria, Requirements, and Resources

<!--
List acceptance criteria and requirements, or provide a link to them if they're in a parent epic or elsewhere.

Also, are there any designs or helpful images that could be added or linked here?
-->

## Dependencies

<!--
Preferably use linked items (blocked by, blocking, relates to) to include any dependencies.

If this issue requires input from specific individuals or teams, make sure that's described here.
-->

#### Is this issue ready?

[Definition of Ready](https://handbook.gitlab.com/handbook/engineering/devops/dev/plan/product-planning/how-we-work/#definition-of-ready)

- [] The work is described in sufficient detail. A reader without previous context or assumed knowledge is able to understand what work is to be undertaken. What we’re doing and why we’re doing it is described.
- [] Acceptance Criteria or Requirements are clearly defined. This should help the assignee understand the scope of the work and verify the intended happy/sad paths are functional and tested.
   - [] Including the relevant license level and feature flags in the Acceptance Criteria or Requirements is also advised.
- [] Other work that blocks or is blocked by the work is linked with the correct relationship.
- [] Relevant resources such as designs, documents, and external links are attached.
- [] Cross-functional dependencies are described; such as needing to ask for Technical Writing assistance.
- [] Documentation that needs to be updated or added is linked.
- [] In case of feature development, confirmed with at least one other engineer (preferably a domain expert).
   - [] In case an item larger than roughly 1 engineer/week, domain expert can provide guidance on breaking down this issue into separate issues (or tasks).

<!--The template is stored at `.gitlab/issue_templates/Product Planning.md` directory if you need to update it -->